/**
 * A module to help with toggle select/deselect all.
 *
 * @module     core/checkbox-toggleall
 * @copyright  2019 Andrew Nicols <andrew@nicols.co.uk>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("core/checkbox-toggleall",["jquery","core/pubsub"],(function($,PubSub){var registered=!1,events={checkboxToggled:"core/checkbox-toggleall:checkboxToggled"},getToggleGroupElements=function(root,toggleGroup,exactMatch){return exactMatch?root.find('[data-action="toggle"][data-togglegroup="'+toggleGroup+'"]'):root.find('[data-action="toggle"][data-togglegroup^="'+toggleGroup+'"]')},getAllTargetCheckboxes=function(root,toggleGroup){const targets=getToggleGroupElements(root,toggleGroup,!1).filter('[data-toggle="target"]'),oldTargets=getToggleGroupElements(root,toggleGroup,!1).filter('[data-toggle="slave"]');return Array.isArray(oldTargets)&&oldTargets.length>0&&(window.console.warn('The use of data-toggle="slave" is deprecated. Please use data-toggle="target" instead.'),targets.concat(oldTargets)),targets},getControlCheckboxes=function(root,toggleGroup,exactMatch){const togglers=getToggleGroupElements(root,toggleGroup,exactMatch).filter('[data-toggle="toggler"]'),oldTogglers=getToggleGroupElements(root,toggleGroup,exactMatch).filter('[data-toggle="master"]');return Array.isArray(oldTogglers)&&oldTogglers.length>0&&(window.console.warn('The use of data-toggle="master" is deprecated. Please use data-toggle="toggler" instead.'),togglers.concat(oldTogglers)),togglers},toggleTargetsFromTogglers=function(e){var targetState,root=e.data.root,target=$(e.target),toggleGroupName=target.data("togglegroup");targetState=target.is(":checkbox")?target.is(":checked"):1===target.data("checkall"),toggleTargetsToState(root,toggleGroupName,targetState)},updateTargetsFromTogglerState=function(root,toggleGroupName){root=$(root);var targetState,target=getControlCheckboxes(root,toggleGroupName,!1);targetState=target.is(":checkbox")?target.is(":checked"):1===target.data("checkall"),toggleTargetsToState(root,toggleGroupName,targetState)},toggleTogglersAndActionElements=function(root,toggleGroupName){var toggleGroupTargets=getAllTargetCheckboxes(root,toggleGroupName);if(toggleGroupTargets.length>0){var toggleGroupCheckedTargets=toggleGroupTargets.filter(":checked"),targetState=toggleGroupTargets.length===toggleGroupCheckedTargets.length;setTogglerStates(root,toggleGroupName,targetState,!0),setActionElementStates(root,toggleGroupName,!toggleGroupCheckedTargets.length)}},getToggleGroupLevels=function(toggleGroupName){var toggleGroups=toggleGroupName.split(" "),toggleGroupLevels=[],toggleGroupLevel="";return toggleGroups.forEach((function(toggleGroupName){toggleGroupLevel+=" "+toggleGroupName,toggleGroupLevels.push(toggleGroupLevel.trim())})),toggleGroupLevels},toggleTargetsToState=function(root,toggleGroupName,targetState){var targets=getAllTargetCheckboxes(root,toggleGroupName);targets.prop("checked",targetState).trigger("change");var checkedTargets=targets.filter(":checked");setTogglerStates(root,toggleGroupName,targetState,!1),setActionElementStates(root,toggleGroupName,!checkedTargets.length),getToggleGroupLevels(toggleGroupName).filter((toggleGroupLevel=>toggleGroupLevel!==toggleGroupName)).forEach((function(toggleGroupLevel){toggleTogglersAndActionElements(root,toggleGroupLevel)})),PubSub.publish(events.checkboxToggled,{root:root,toggleGroupName:toggleGroupName,targets:targets,checkedTargets:checkedTargets,anyChecked:targetState})},toggleTogglersFromTargets=function(e){var root=e.data.root,toggleGroupName=$(e.target).data("togglegroup"),targets=getAllTargetCheckboxes(root,toggleGroupName),checkedTargets=targets.filter(":checked");getToggleGroupLevels(toggleGroupName).forEach((function(toggleGroupLevel){toggleTogglersAndActionElements(root,toggleGroupLevel)})),PubSub.publish(events.checkboxToggled,{root:root,toggleGroupName:toggleGroupName,targets:targets,checkedTargets:checkedTargets,anyChecked:!!checkedTargets.length})},setActionElementStates=function(root,toggleGroupName,disableActionElements){(function(root,toggleGroup){return getToggleGroupElements(root,toggleGroup,!0).filter('[data-toggle="action"]')})(root,toggleGroupName).prop("disabled",disableActionElements)},setTogglerStates=function(root,toggleGroupName,targetState,exactMatch){var togglers=getControlCheckboxes(root,toggleGroupName,exactMatch);togglers.prop("checked",targetState),togglers.each((function(i,togglerElement){var targetString;if(togglerElement=$(togglerElement),targetString=targetState?togglerElement.data("toggle-deselectall"):togglerElement.data("toggle-selectall"),togglerElement.is(":checkbox")){var togglerLabel=root.find('[for="'+togglerElement.attr("id")+'"]');togglerLabel.length&&togglerLabel.html()!==targetString&&togglerLabel.html(targetString)}else togglerElement.text(targetString),togglerElement.data("checkall",targetState?0:1)}))};return{init:function(){!function(){if(!registered){registered=!0;var root=$(document.body);root.on("click",'[data-action="toggle"][data-toggle="toggler"]',{root:root},toggleTargetsFromTogglers),root.on("click",'[data-action="toggle"][data-toggle="target"]',{root:root},toggleTogglersFromTargets),document.querySelectorAll('[data-action="toggle"][data-toggle="master"]').length>0&&(window.console.warn('The use of data-toggle="master" is deprecated. Please use data-toggle="toggler" instead.'),root.on("click",'[data-action="toggle"][data-toggle="master"]',{root:root},toggleTargetsFromTogglers)),document.querySelectorAll('[data-action="toggle"][data-toggle="slave"]').length>0&&(window.console.warn('The use of data-toggle="slave" is deprecated. Please use data-toggle="target" instead.'),root.on("click",'[data-action="toggle"][data-toggle="slave"]',{root:root},toggleTogglersFromTargets))}}()},events:events,setGroupState:function(root,toggleGroupName,targetState){root=$(root),setTogglerStates(root,toggleGroupName,targetState,!0),toggleTargetsToState(root,toggleGroupName,targetState)},updateSlavesFromMasterState:function(root,toggleGroupName){window.console.warn("The use of updateSlavesFromMasterState is deprecated. Please use updateTargetsFromTogglerState instead."),updateTargetsFromTogglerState(root,toggleGroupName)},updateTargetsFromTogglerState:updateTargetsFromTogglerState}}));

//# sourceMappingURL=checkbox-toggleall.min.js.map